--
--  Copyright 2018 Autodesk, Inc. All rights reserved.
--
rollout DYNgifChecker ""
(
  --- Local Variables
  local LOClogItems = #()
  local LOCgifGlobalCount = 0
  local LOCgifNoAlternativeCount = 0
  local LOCgifLocalCount = 0
  local LOCgifModifiedCount = 0

  --- Local Functions
  fn addListViewItem FUNlistItemText FUNsubItemText1 FUNsubItemText2 FUNisEnabled =
  (
    local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" FUNlistItemText
    
    if FUNisEnabled != true then 
        LOClistItem.ForeColor = DYNFUNdnColor (DYNINIgreyedOutColor)
    
    LOClistItem.SubItems.add FUNsubItemText1
    LOClistItem.SubItems.add FUNsubItemText2
      
    append DYNgifChecker.LOClogItems LOClistItem
  )
  
  fn DYNFUNcheckGif FUNbitmap FUNmapPath FUNmatlType FUNdoUpdate FUNmultiMatName FUNindex =
  (
    if classof FUNbitmap == Bitmaptexture then
    (
      local sourceGifFile = FUNbitmap.FileName
      
      if (stricmp (getfilenametype sourceGifFile) ".gif") == 0 then
      (
        local targetPngFile = FUNmapPath + ((getFileNameFile sourceGifFile) + ".png") 
        if (doesFileExist targetPngFile) then
        (
          -- If a suitable PNG replacement image exists, swap the GIF to the PNG
          if FUNdoUpdate then
          ( 
            FUNbitmap.FileName = targetPngFile
            -- Sometimes, after a render with Arnold, the first attempt to set the bitmap
            -- will fail. If that is the case, simply try again as a workaround. 
            local LOCupdateOK = true 
            if (stricmp targetPngFile FUNbitmap.FileName != 0) then
            (
              print "CivilView Gif Checker WARNING : Updating the bitmap failed. Retrying..."
              FUNbitmap.FileName = targetPngFile
              -- If we still could not set it, give up.
              if (stricmp targetPngFile FUNbitmap.FileName != 0) then
              (
                print "CivilView Gif Checker ERROR : Retry failed...Giving up."
                LOCupdateOK = false
              )
            )
            if LOCupdateOK then
            (
              DYNgifChecker.LOCgifModifiedCount = DYNgifChecker.LOCgifModifiedCount + 1
            )
          )
          else
          (
            DYNgifChecker.LOCgifGlobalCount = DYNgifChecker.LOCgifGlobalCount + 1
            DYNgifChecker.LOCgifLocalCount = DYNgifChecker.LOCgifLocalCount + 1
            
            local LOCstringStream = stringStream "" 
            format DYNuiResourcesLabels[681] ("\"" + FUNmultiMatName + "\"") ("\"" + (filenameFromPath sourceGifFile) + "\"") FUNmatlType to:LOCstringStream
            addListViewItem (LOCstringStream as string) (FUNindex as string) (filenamefrompath targetPngFile) true
          )   
        )
        else
        (
          DYNgifChecker.LOCgifGlobalCount = DYNgifChecker.LOCgifGlobalCount + 1
          DYNgifChecker.LOCgifLocalCount = DYNgifChecker.LOCgifLocalCount + 1
          DYNgifChecker.LOCgifNoAlternativeCount = DYNgifChecker.LOCgifNoAlternativeCount + 1 
          
          local LOCstringStream = stringStream "" 
          format DYNuiResourcesLabels[681] ("\"" + FUNmultiMatName + "\"") ("\"" + (filenameFromPath sourceGifFile) + "\"") FUNmatlType to:LOCstringStream
          addListViewItem (LOCstringStream as string) (FUNindex as string) DYNuiResourcesLabels[680] true
        )
      )
    )
  )

  fn DYNFUNcheckStandardMaterial FUNmaterial FUNmultiMatName FUNmapPath FUNdoUpdate FUNindex =
  (
     if classof FUNmaterial == Standardmaterial then
     (
       local LOCmatlType = DYNuiResourcesLabels[676]
       if classof FUNmaterial.DiffuseMap == Bitmaptexture then DYNFUNcheckGif FUNmaterial.DiffuseMap FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       if classof FUNmaterial.OpacityMap == Bitmaptexture then DYNFUNcheckGif FUNmaterial.OpacityMap FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       if classof FUNmaterial.BumpMap == Bitmaptexture then DYNFUNcheckGif FUNmaterial.BumpMap FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       
       if classof FUNmaterial.DiffuseMap == Mask then
       (
         if classof FUNmaterial.DiffuseMap.Mask == Bitmaptexture then DYNFUNcheckGif FUNmaterial.DiffuseMap.Mask FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       )

       if classof FUNmaterial.DiffuseMap == Mix then
       (
         if classof FUNmaterial.DiffuseMap.Map1 == Bitmaptexture then DYNFUNcheckGif FUNmaterial.DiffuseMap.Map1 FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
         if classof FUNmaterial.DiffuseMap.Map2 == Bitmaptexture then DYNFUNcheckGif FUNmaterial.DiffuseMap.Map2 FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       )
     )
  )

  fn DYNFUNcheckPhysicalMaterial FUNmaterial FUNmultiMatName FUNmapPath FUNdoUpdate FUNindex =
  (
     if classof FUNmaterial == PhysicalMaterial then
     (
       local LOCmatlType = DYNuiResourcesLabels[677]
       if classof FUNmaterial.base_color_map == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_map FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       if classof FUNmaterial.bump_map == Bitmaptexture then DYNFUNcheckGif FUNmaterial.bump_map FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex                     
       if classof FUNmaterial.cutout_map == Bitmaptexture then DYNFUNcheckGif FUNmaterial.cutout_map FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       
       if classof FUNmaterial.base_color_map == Mask then
       (
         if classof FUNmaterial.base_color_map.Mask == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_map.Mask FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       )

       if classof FUNmaterial.base_color_map == Mix then
       (
         if classof FUNmaterial.base_color_map.Map1 == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_map.Map1 FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
         if classof FUNmaterial.base_color_map.Map2 == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_map.Map2 FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
       )
       
     )
  )
  
  fn DYNFUNcheckArnoldStandardSurfaceMaterial FUNmaterial FUNmultiMatName FUNmapPath FUNdoUpdate FUNindex = 
  (
    if classof FUNmaterial == ai_standard_surface then
    (
      local LOCmatlType = DYNuiResourcesLabels[686]
      if classof FUNmaterial.base_color_shader == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_shader FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
      if classof FUNmaterial.diffuse_roughness_shader == Bitmaptexture then DYNFUNcheckGif FUNmaterial.diffuse_roughness_shader FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
      if classof FUNmaterial.opacity_shader == Bitmaptexture then DYNFUNcheckGif FUNmaterial.opacity_shader FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
      
      if classof FUNmaterial.base_color_shader == Mask then
      (
        if classof FUNmaterial.base_color_shader.Mask == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_shader.Mask FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
      )

      if classof FUNmaterial.base_color_shader == Mix then
      (
        if classof FUNmaterial.base_color_shader.Map1 == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_shader.Map1 FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
        if classof FUNmaterial.base_color_shader.Map2 == Bitmaptexture then DYNFUNcheckGif FUNmaterial.base_color_shader.Map2 FUNmapPath LOCmatlType FUNdoUpdate FUNmultiMatName FUNindex
      )
    )
  )

  fn DYNcheckMultiMaterial FUNmultiMatName FUNmapPath FUNdoUpdate =
  (
    DYNgifChecker.LOCgifLocalCount = 0
    local multiMat = sceneMaterials[FUNmultiMatName]
  
    if classOf multiMat == Multimaterial then
    (
      for i = 1 to multiMat.count do
      (
        local LOCmaterial = multiMat[i]
         
        if classOf LOCmaterial == Standardmaterial then DYNFUNcheckStandardMaterial LOCmaterial FUNmultiMatName FUNmapPath FUNdoUpdate i
        if classOf LOCmaterial == PhysicalMaterial then DYNFUNcheckPhysicalMaterial LOCmaterial FUNmultiMatName FUNmapPath FUNdoUpdate i
        if classof LOCmaterial == ai_standard_surface then DYNFUNcheckArnoldStandardSurfaceMaterial LOCmaterial FUNmultiMatName FUNmapPath FUNdoUpdate i
        
        if classof LOCmaterial == DoubleSided then
        (
          if classOf LOCmaterial.material1 == Standardmaterial then DYNFUNcheckStandardMaterial LOCmaterial.material1 FUNmultiMatName FUNmapPath FUNdoUpdate i
          if classOf LOCmaterial.material1 == PhysicalMaterial then DYNFUNcheckPhysicalMaterial LOCmaterial.material1 FUNmultiMatName FUNmapPath FUNdoUpdate i
          if classof LOCmaterial.material1 == ai_standard_surface then DYNFUNcheckArnoldStandardSurfaceMaterial LOCmaterial.material1 FUNmultiMatName FUNmapPath FUNdoUpdate i
    
          if classOf LOCmaterial.material2 == Standardmaterial then DYNFUNcheckStandardMaterial LOCmaterial.material2 FUNmultiMatName FUNmapPath FUNdoUpdate i
          if classOf LOCmaterial.material2 == PhysicalMaterial then DYNFUNcheckPhysicalMaterial LOCmaterial.material2 FUNmultiMatName FUNmapPath FUNdoUpdate i
          if classof LOCmaterial.material2 == ai_standard_surface then DYNFUNcheckArnoldStandardSurfaceMaterial LOCmaterial.material2 FUNmultiMatName FUNmapPath FUNdoUpdate i
        )
      )
      
      if DYNgifChecker.LOCgifLocalCount == 0 then
      (
        local LOCstringStream = stringStream "" 
        format DYNuiResourcesLabels[683] ("\"" + FUNmultiMatName + "\"") (DYNgifChecker.LOCgifLocalCount as string) to:LOCstringStream
 
        addListViewItem (LOCstringStream as string) "" "" true
      )
    )
    else
    (
      local LOCstringStream = stringStream "" 
      format DYNuiResourcesLabels[684] ("\"" + FUNmultiMatName + "\"") to:LOCstringStream
      
      addListViewItem (LOCstringStream as string) "" "" false
    )  
  )
  
  fn DYNFUNcheckCivilViewMaterials FUNdoUpdate =
  (
    DYNgifChecker.dnLog.Items.clear()
    DYNgifChecker.dnLog.beginUpdate()
    DYNgifChecker.dnLog.suspendLayout()
    
    LOClogItems = #()
    DYNgifChecker.LOCgifGlobalCount = 0
    DYNgifChecker.LOCgifModifiedCount = 0
    DYNgifChecker.LOCgifNoAlternativeCount = 0
    
    -- Check or Update CivilViewSurfaces material
    DYNcheckMultiMaterial DYNmatNameSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + DYNfolderSeperator) FUNdoUpdate

    -- Check or Update CivilViewVehicles material
    DYNcheckMultiMaterial DYNmatNameVehicles (DYNcountryPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameVehicleMaps + DYNfolderSeperator) FUNdoUpdate

    -- Check or Update CivilViewObjects material
    DYNcheckMultiMaterial DYNmatNameObjects (DYNcountryPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameSignMaps + DYNfolderSeperator) FUNdoUpdate

    -- Check or Update CivilViewTrees material
    DYNcheckMultiMaterial DYNmatNameTrees (DYNcountryPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameTreeMaps + DYNfolderSeperator) FUNdoUpdate

    -- Check or Update CivilViewMarkings material
    DYNcheckMultiMaterial DYNmatNameMarkings (DYNcountryPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameMarkingMaps + DYNfolderSeperator) FUNdoUpdate

    -- Check or Update CivilViewRails material
    DYNcheckMultiMaterial DYNmatNameRails (DYNcountryPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameRailMaps + DYNfolderSeperator) FUNdoUpdate

    -- Check or Update CivilViewBuildings material
    DYNcheckMultiMaterial DYNmatNameBuildings (DYNcountryPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameBuildingMaps + DYNfolderSeperator) FUNdoUpdate
    
    DYNgifChecker.dnLog.Items.AddRange LOClogItems
    DYNgifChecker.dnLog.endUpdate()
    DYNgifChecker.dnLog.resumeLayout()
    DYNgifChecker.dnLog.refresh()
    
    if (DYNgifChecker.LOCgifGlobalCount > DYNgifChecker.LOCgifNoAlternativeCount) then
    (
      DYNgifChecker.BUDYNapply.enabled = true
      DYNgifChecker.BUDYNokok.enabled = false
    )
    else
    (
      DYNgifChecker.BUDYNapply.enabled = false
      DYNgifChecker.BUDYNokok.enabled = true
    )
    
    if (DYNgifChecker.LOCgifModifiedCount > 0) then
    (
      local LOCstringStream = stringStream "" 
      format DYNuiResourcesLabels[682] (DYNgifChecker.LOCgifModifiedCount as string) to:LOCstringStream
      MessageBox (LOCstringStream as string) title:DYNuiResourcesTitlebars[3] beep:false
    )
    
    if DYNgifChecker.LOCgifGlobalCount == 0 then
    (
      DYNgifChecker.LBDYNstatus.text = DYNuiResourcesLabels[679]
    )
    else
    (
      if DYNgifChecker.LOCgifGlobalCount > DYNgifChecker.LOCgifNoAlternativeCount then
      (
        DYNgifChecker.LBDYNstatus.text = DYNuiResourcesLabels[678]
      )
      else
      (
        DYNgifChecker.LBDYNstatus.text = DYNuiResourcesLabels[685]
      )
    )
  )

  --- Rollout Controls
  dotNetControl dnLog      "System.Windows.Forms.ListView"    pos:[15,15]  width:733 height:277 
  dotNetControl dnProgress "System.Windows.Forms.ProgressBar" pos:[15,331] width:733 height:14

  button BUDYNokok   pos:[60,300]  width:90  height:22
  button BUDYNapply  pos:[334,300] width:90  height:22
  button BUDYNcanc   pos:[603,300] width:90  height:22
  label  LBDYNstatus pos:[15,351]  width:733

  --- Rollout Control Events
  on DYNgifChecker open do
  (
    DYNgifChecker.title     = DYNuiRolloutNames[69]
  
    -- Set up listView defaults
    DYNFUNdnListViewStyle dnLog false false
    dnLog.sorting = DYNdnSortOrderClass.none
    local LOCcol1 = dnLog.Columns.add DYNuiResourcesGroups[16] 489;     LOCcol1.textAlign = DYNdnHorAlignClass.left
    local LOCcol2 = dnLog.Columns.add DYNuiResourcesLvColumns[120] 40;  LOCcol2.textAlign = DYNdnHorAlignClass.Center
    local LOCcol3 = dnLog.Columns.add DYNuiResourcesLvColumns[144] 180; LOCcol3.textAlign = DYNdnHorAlignClass.left
 
    -- Apply rollout localisation
    BUDYNokok.text            = DYNuiResourcesButtons[1]
    BUDYNapply.text           = DYNuiResourcesButtons[2]
    BUDYNcanc.text            = DYNuiResourcesButtons[3]
    
    DYNFUNcheckCivilViewMaterials false
    

    
  )

  on DYNgifChecker close do
  (
    DYNFUNonDialogClose()
  )

  on BUDYNapply pressed do
  (
     DYNFUNcheckCivilViewMaterials true
  )

  on BUDYNokok pressed do
  (
    destroyDialog DYNgifChecker
  )

  on BUDYNcanc pressed do
  (
    destroyDialog DYNgifChecker
  )
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA7yfjAjWOY7o2Qkhf7QzALqwcLFSdyFbPF
-- F/HFWTPDaQPcv3BiZme+6om17SSqHzyuD10q1Ckzf/3UVhOGPk50fnIo+ShmteuK
-- pKxTU+CuWTQEdxEztN0CaUqAVs0GT0yHsGL0fzkTowvj1p8V9bHGJkjjhMkv/YBK
-- p7QOZ/qFoFjlehBxQK0iUVNq3M9m5AbkX0PGBgX7gc7FimwPbOjMnItDW54Jyp+4
-- YtfQBEgK9Yo7KkXpal4LWiaX3MZYUAPjRind8ogTaRg3GMCUN7lJtNGZO73NBviL
-- PngVBEza/KdUCwkidin13IjXPBktqhYbwo8hHxIWAxLo4Uh/g0Sj
-- -----END-SIGNATURE-----